/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class InfoAlgo {
    private static Logger log = Logger.getLogger(InfoAlgo.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                CK_TOKEN_INFO cK_TOKEN_INFO;
                ResultatInfo resultatInfo = new ResultatInfo("Obtenir des informations sur l'algorithme ");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo.setInfos(linkedHashMap);
                try {
                    cK_TOKEN_INFO = pKCS11.C_GetTokenInfo(l);
                    if (cK_TOKEN_INFO != null) {
                        resultatInfo.appendTraitement(TraitementsUtil.getNomAlgo(l2).replaceAll("_", " ").replaceAll("CKM", "").trim() + " de la carte " + new String(cK_TOKEN_INFO.label).trim() + " (C_GetMechanismInfo)");
                    } else {
                        resultatInfo.appendTraitement("(C_GetMechanismInfo)");
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    // empty catch block
                }
                try {
                    cK_TOKEN_INFO = pKCS11.C_GetMechanismInfo(l, l2);
                    if (cK_TOKEN_INFO == null) {
                        log.error((Object)"L'operation a retourne des informations nulles");
                        throw new ExceptionTraitement(9, "L'op\u00e9ration a retourn\u00e9 des informations nulles");
                    }
                    linkedHashMap.put("Taille minimale de la cl\u00e9 pour l'algorithme (l'unit\u00e9 de grandeur (bits ou octets) d\u00e9pend du type d'algorithme)?", Long.toString(cK_TOKEN_INFO.ulMinKeySize));
                    linkedHashMap.put("Taille maximale de la cl\u00e9 pour l'algorithme (l'unit\u00e9 de grandeur (bits ou octets) d\u00e9pend du type d'algorithme)?", Long.toString(cK_TOKEN_INFO.ulMaxKeySize));
                    linkedHashMap.put("L'algorithme est-il directement appliqu\u00e9 sur la carte?", (cK_TOKEN_INFO.flags & 1L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour le chiffrement?", (cK_TOKEN_INFO.flags & 0x100L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour le d\u00e9chiffrement?", (cK_TOKEN_INFO.flags & 0x200L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour r\u00e9aliser un condensat?", (cK_TOKEN_INFO.flags & 0x400L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour r\u00e9aliser une signature?", (cK_TOKEN_INFO.flags & 0x800L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour r\u00e9cup\u00e9rer une donn\u00e9e depuis une signature?", (cK_TOKEN_INFO.flags & 0x1000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour r\u00e9aliser la v\u00e9rification d\u2019une signature ou d\u2019un MAC (Message Authentication Code)?", (cK_TOKEN_INFO.flags & 0x2000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour r\u00e9aliser la v\u00e9rification d\u2019une signature ou d\u2019un MAC (Message Authentication Code) avec r\u00e9cup\u00e9ration de la donn\u00e9e depuis la signature?", (cK_TOKEN_INFO.flags & 0x4000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour g\u00e9n\u00e9rer une cl\u00e9 secr\u00e8te?", (cK_TOKEN_INFO.flags & 0x8000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour g\u00e9n\u00e9rer une paire de cl\u00e9s (publique/priv\u00e9e)?", (cK_TOKEN_INFO.flags & 0x10000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour chiffrer une cl\u00e9?", (cK_TOKEN_INFO.flags & 0x20000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour d\u00e9chiffrer une cl\u00e9?", (cK_TOKEN_INFO.flags & 0x40000L) != 0L ? "Oui" : "Non");
                    linkedHashMap.put("L'algorithme peut-il \u00eatre utilis\u00e9 pour d\u00e9river une cl\u00e9 depuis une autre cl\u00e9?", (cK_TOKEN_INFO.flags & 0x80000L) != 0L ? "Oui" : "Non");
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(10, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(10, "Une erreur inattendue est survenue");
        }
    }
}

